//Experiment No.9
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at    
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//This Source file is Written by Dr. T. Subbulaskhmi, Professor, 
//School of Computing Science and Engineering, VIT University Chennai 
//using the NARVAL examples of Scilab for Network Topology Creation  
//The Operating System used for writing the code found in this file is Windows 8
//SCILAB version 5.5.2 and NARVAL toolbox version 3.1//This Program is Written by Souarv kumar Surya(15bce1364),Prayag Bhatia (15bce1363),Maaz Ahmed (15bce1261), School of Computing Science and Engineering, VIT University Chennai using the NARVAL examples of Scilab for finding the shortest path 
//This is the scilab code to find the Shortest path from source to destination in Mesh topology network using flood for 11 nodes. 
clear;
clc;

NameOfNetwork='mesh topology with 11 nodes';// graph name
NumberOfNodes=11;//no. of nodes
//every edge has head and tail.
EndingNodesOfConnection=[2 3 4 3 4 5 5 5 5 6 6 6 6 6 7 7 7 7 7 7 8 8 8 8 8 8 8 9 9 9 9 9 9 9 9 10 10 10 10 10 10 10 10 10 11 11 11 11 11 11 11 11 11 11];// tail of eatch edge, this is a node from a edge or link is originating 
StartNodesOfConnection=[1 2 3 1 2 1 2 3 4 1 2 3 4 5 1 2 3 4 5 6 1 2 3 4 5 6 7 1 2 3 4 5 6 7 8 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9 10];//head of each edge,this is a node where edge or link is terminating 
// so, an edge can be represent as (tail,head),tail and head both are node no. eg.:   tail[1]=2,head[1]=1 means edge 1 is originating from 2 and terminating on 1 that implies there is an edge betweem node 1 and   node 2
XCoordinatesOfNodes=[100 400 100 400 550 200 350 750 700 450 800];// x-coordinate of each node
YCoordinatesOfNodes=[100 100 400 400 100 500 650 350 700 450 650];//y-coordinate of each node
[TopologyGraph]=NL_G_MakeGraph(NameOfNetwork,NumberOfNodes,EndingNodesOfConnection,StartNodesOfConnection,XCoordinatesOfNodes,YCoordinatesOfNodes)//application of NL_G_MakeGraph
NetworkSize=length(TopologyGraph.node_x);//real network size
NetworkQuantity=length(TopologyGraph.head);//quantity of network links
[Node1,Node2]=NL_F_RandIntNiNj(NetworkSize)//selection of two distinct nodes
TimeToLive=5;//Time-To-Live update
[path]=NL_R_Flood(TopologyGraph,Node1,Node2,TimeToLive)//application of NL_R_Flood
ShortestPath=NL_G_Nodes2Path(path,TopologyGraph);//links of the shortest path
EdgeColor=ones(1,NetworkQuantity);//display the path between i and j: edge color
EdgeBorder=1.5*ones(1,NetworkQuantity);//edge width
EdgeColor(ShortestPath)=5;//define path color
EdgeBorder(ShortestPath)=5;//define width color
NodeBorder=4*ones(1,NetworkSize);//node border
NodeBorder(path)=10;//node border for source to destination path
TopologyGraph.node_border=NodeBorder;//node border
TopologyGraph.edge_color=EdgeColor;//define edge color
TopologyGraph.edge_width=EdgeBorder;//edge width
WindowNumber=1;//window index
GraphVisualize=NL_G_ShowGraphN(TopologyGraph,WindowNumber);//graph visualization
xtitle("Shortest path in mesh Topology network using flood for 11 nodes","X-Nodes","Y-Nodes");
//This is the scilab code to find the Shortest path from source to destination in Mesh topology network using flood for 15 nodes. 
NameOfNetwork='mesh topology with 15 nodes';// graph name
NumberOfNodes=15;//no. of nodes
//every edge has head and tail.
EndingNodesOfConnection=[2 3 4 3 4 5 5 5 5 6 6 6 6 6 7 7 7 7 7 7 8 8 8 8 8 8 8 9 9 9 9 9 9 9 9 10 10 10 10 10 10 10 10 10 11 11 11 11 11 11 11 11 11 11 12 12 12 12 12 12 12 12 12 12 12 13 13 13 13 13 13 13 13 13 13 13 13 14 14 14 14 14 14 14 14 14 14 14 14 14 15 15 15 15 15 15 15 15 15 15 15 15 15 15];// tail of eatch edge, this is a node from a edge or link is originating 
StartNodesOfConnection=[1 2 3 1 2 1 2 3 4 1 2 3 4 5 1 2 3 4 5 6 1 2 3 4 5 6 7 1 2 3 4 5 6 7 8 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9 10 1 2 3 4 5 6 7 8 9 10 11 1 2 3 4 5 6 7 8 9 10 11 12 1 2 3 4 5 6 7 8 9 10 11 12 13 1 2 3 4 5 6 7 8 9 10 11 12 13 14];//head of each edge,this is a node where edge or link is terminating 
// so, an edge can be represent as (tail,head),tail and head both are node no. eg.:   tail[1]=2,head[1]=1 means edge 1 is originating from 2 and terminating on 1 that implies there is an edge betweem node 1 and   node 2
XCoordinatesOfNodes=[100 400 100 400 550 200 300 750 700 450 800 900 600 600 200]; // x-coordinate of each node
YCoordinatesOfNodes=[100 100 400 400 100 650 800 350 700 450 650 900 500 400 300];//y-coordinate of each node
//node i can represent as node_x[i],node_y[i]
[TopologyGraph]=NL_G_MakeGraph(NameOfNetwork,NumberOfNodes,EndingNodesOfConnection,StartNodesOfConnection,XCoordinatesOfNodes,YCoordinatesOfNodes)//application of NL_G_MakeGraph
NetworkSize=length(TopologyGraph.node_x);//real network size
NetworkQuantity=length(TopologyGraph.head);//quantity of network links
[Node1,Node2]=NL_F_RandIntNiNj(NetworkSize)//selection of two distinct nodes
TimeToLive=5;//Time-To-Live update
[path]=NL_R_Flood(TopologyGraph,Node1,Node2,TimeToLive)//application of NL_R_Flood
ShortestPath=NL_G_Nodes2Path(path,TopologyGraph);//links of the shortest path
EdgeColor=ones(1,NetworkQuantity);//display the path between i and j: edge color
EdgeBorder=1.5*ones(1,NetworkQuantity);//edge width
EdgeColor(ShortestPath)=5;//define path color
EdgeBorder(ShortestPath)=5;//define width color
NodeBorder=4*ones(1,NetworkSize);//node border
NodeBorder(path)=10;//node border for source to destination path
TopologyGraph.node_border=NodeBorder;//node border
TopologyGraph.edge_color=EdgeColor;//define edge color
TopologyGraph.edge_width=EdgeBorder;//edge width
WindowNumber=2;//window index
GraphVisualize=NL_G_ShowGraphN(TopologyGraph,WindowNumber);//graph visualization
xtitle("Shortest path in mesh Topology network using flood for 15 nodes","X-Nodes","Y-Nodes");
